<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>404 - صفحه یافت نشد - گواهیتو</title>
    <link rel="icon" type="image/png" href="assets/images/logo.png">
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Vazirmatn', sans-serif;
            background: linear-gradient(135deg, #1e293b 0%, #334155 50%, #475569 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #e2e8f0;
            overflow: hidden;
            position: relative;
        }
        
        /* Animated background */
        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: 
                radial-gradient(circle at 20% 80%, rgba(120, 119, 198, 0.3) 0%, transparent 50%),
                radial-gradient(circle at 80% 20%, rgba(255, 119, 198, 0.3) 0%, transparent 50%),
                radial-gradient(circle at 40% 40%, rgba(120, 219, 255, 0.2) 0%, transparent 50%);
            animation: backgroundShift 20s ease-in-out infinite;
            z-index: 1;
        }
        
        @keyframes backgroundShift {
            0%, 100% { transform: scale(1) rotate(0deg); }
            50% { transform: scale(1.1) rotate(1deg); }
        }
        
        .container {
            position: relative;
            z-index: 2;
            width: 100%;
            max-width: 500px;
            padding: 2rem;
        }
        
        .glass-card {
            background: rgba(30, 41, 59, 0.7);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(148, 163, 184, 0.2);
            border-radius: 20px;
            padding: 2.5rem;
            margin-bottom: 1.5rem;
            box-shadow: 
                0 8px 32px rgba(0, 0, 0, 0.3),
                inset 0 1px 0 rgba(255, 255, 255, 0.1);
            position: relative;
            overflow: hidden;
        }
        
        .glass-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 1px;
            background: linear-gradient(90deg, transparent, rgba(168, 85, 247, 0.5), transparent);
        }
        
        .error-header {
            text-align: center;
            margin-bottom: 2rem;
        }
        
        .error-code {
            font-size: 4rem;
            font-weight: 800;
            color: #f59e0b;
            margin-bottom: 0.5rem;
            text-shadow: 0 0 20px rgba(245, 158, 11, 0.5);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 1rem;
        }
        
        .not-found-icon {
            width: 60px;
            height: 60px;
            background: #f59e0b;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2rem;
            color: white;
            box-shadow: 0 0 20px rgba(245, 158, 11, 0.5);
        }
        
        .error-title {
            font-size: 1.5rem;
            font-weight: 600;
            color: #f59e0b;
            margin-bottom: 0.5rem;
        }
        
        .error-description {
            color: #94a3b8;
            font-size: 1rem;
            line-height: 1.6;
        }
        
        .action-card {
            text-align: center;
        }
        
        .action-message {
            color: #cbd5e1;
            font-size: 1.1rem;
            margin-bottom: 2rem;
            line-height: 1.6;
        }
        
        .home-button {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            background: linear-gradient(135deg, #a855f7 0%, #8b5cf6 100%);
            color: white;
            text-decoration: none;
            padding: 1rem 2rem;
            border-radius: 12px;
            font-weight: 600;
            font-size: 1rem;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(168, 85, 247, 0.3);
            border: 1px solid rgba(168, 85, 247, 0.2);
        }
        
        .home-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(168, 85, 247, 0.4);
            background: linear-gradient(135deg, #9333ea 0%, #7c3aed 100%);
        }
        
        .home-button:active {
            transform: translateY(0);
        }
        
        .footer {
            text-align: center;
            margin-top: 2rem;
            color: #64748b;
            font-size: 0.875rem;
        }
        
        .footer a {
            color: #a855f7;
            text-decoration: none;
            transition: color 0.3s ease;
        }
        
        .footer a:hover {
            color: #8b5cf6;
        }
        
        /* Responsive design */
        @media (max-width: 768px) {
            .container {
                padding: 1rem;
            }
            
            .glass-card {
                padding: 2rem;
            }
            
            .error-code {
                font-size: 3rem;
            }
            
            .not-found-icon {
                width: 50px;
                height: 50px;
                font-size: 1.5rem;
            }
        }
        
        @media (max-width: 480px) {
            .error-code {
                font-size: 2.5rem;
                flex-direction: column;
                gap: 0.5rem;
            }
            
            .glass-card {
                padding: 1.5rem;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Error Information Card -->
        <div class="glass-card error-header">
            <div class="error-code">
                404
                <div class="not-found-icon">🔍</div>
            </div>
            <h1 class="error-title">صفحه یافت نشد</h1>
            <p class="error-description">صفحه‌ای که به دنبال آن هستید وجود ندارد یا منتقل شده است.</p>
        </div>
        
        <!-- Action Card -->
        <div class="glass-card action-card">
            <p class="action-message">اگر این خطا را مکرراً مشاهده می‌کنید، با مدیر سیستم تماس بگیرید.</p>
            
            <a href="https://gavahito.ir/" class="home-button">
                <span>🏠</span>
                بازگشت به خانه
            </a>
        </div>
        
        <!-- Footer -->
        <div class="footer">
            <p>گواهیتو Admin Panel - <a href="https://gavahito.ir/">gavahito.ir</a> 2024 ©</p>
        </div>
    </div>
</body>
</html>
