<?php
/**
 * Database Configuration
 * این فایل به صورت خودکار توسط install.php ایجاد می‌شود
 * اگر این فایل وجود ندارد یا خالی است، لطفاً install.php را اجرا کنید
 */

class Database {
    public $host = "";
    public $database = "";
    public $username = "";
    public $password = "";
    private $conn;

    public function getConnection() {
        // Check if database is configured
        if (empty($this->host) || empty($this->database) || empty($this->username)) {
            if (php_sapi_name() !== 'cli') {
                // Check if install.lock exists
                if (!file_exists(__DIR__ . '/../install.lock')) {
                    header('Location: install.php');
                    exit;
                }
            }
            throw new Exception("دیتابیس پیکربندی نشده است. لطفاً install.php را اجرا کنید.");
        }
        
        $this->conn = null;

        try {
            $this->conn = new PDO(
                "mysql:host=" . $this->host . ";dbname=" . $this->database . ";charset=utf8mb4",
                $this->username,
                $this->password,
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES => false
                ]
            );
            
            // Set charset explicitly after connection
            $this->conn->exec("SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci");
            $this->conn->exec("SET CHARACTER SET utf8mb4");
            $this->conn->exec("SET character_set_connection=utf8mb4");
            
        } catch(PDOException $exception) {
            error_log("Connection error: " . $exception->getMessage());
            throw new Exception("خطا در اتصال به دیتابیس");
        }

        return $this->conn;
    }
}
?>
