<?php
/**
 * SMTP Configuration for گواهیتو Admin Panel
 * تنظیمات SMTP برای پنل مدیریت گواهیتو
 */

// SMTP Settings - تنظیمات SMTP
define('SMTP_ENABLED', true); // فعال/غیرفعال کردن SMTP
define('SMTP_HOST', 'mail.yadinom.ir'); // آدرس سرور SMTP
define('SMTP_PORT', 587); // پورت SMTP (TLS)
define('SMTP_SECURE', 'TLS'); // نوع امنیت (tls یا ssl)
define('SMTP_USERNAME', 'info@yadinom.ir'); // نام کاربری SMTP
define('SMTP_PASSWORD', ']q;o-$,ka{J+l7DD'); // رمز عبور SMTP
define('SMTP_FROM_EMAIL', 'info@yadinom.ir'); // ایمیل فرستنده (از سرور SMTP)
define('SMTP_FROM_NAME', 'Gavahito Security System'); // نام فرستنده

// Alternative SMTP Providers - ارائه‌دهندگان جایگزین SMTP
$smtpProviders = [
    'gmail' => [
        'host' => 'smtp.gmail.com',
        'port' => 587,
        'secure' => 'tls',
        'username' => 'your-email@gmail.com',
        'password' => 'your-app-password'
    ],
    'yahoo' => [
        'host' => 'smtp.mail.yahoo.com',
        'port' => 587,
        'secure' => 'tls',
        'username' => 'your-email@yahoo.com',
        'password' => 'your-app-password'
    ],
    'outlook' => [
        'host' => 'smtp-mail.outlook.com',
        'port' => 587,
        'secure' => 'tls',
        'username' => 'your-email@outlook.com',
        'password' => 'your-password'
    ],
    'sendgrid' => [
        'host' => 'smtp.sendgrid.net',
        'port' => 587,
        'secure' => 'tls',
        'username' => 'apikey',
        'password' => 'your-sendgrid-api-key'
    ]
];

// Get SMTP configuration
function getSMTPConfig($provider = 'gmail') {
    global $smtpProviders;
    
    if (isset($smtpProviders[$provider])) {
        return $smtpProviders[$provider];
    }
    
    // Return default Gmail config
    return $smtpProviders['gmail'];
}



// Send email using SMTP with improved error handling
function sendEmailSMTP($to, $subject, $message, $replyTo = '') {
    if (!SMTP_ENABLED) {
        error_log("SMTP is disabled");
        return false;
    }
    
    try {
        // Include PHPMailer with proper error handling
        $phpmailerPath = __DIR__ . '/../vendor/phpmailer/phpmailer/src/';
        
        if (!file_exists($phpmailerPath . 'PHPMailer.php')) {
            error_log("PHPMailer files not found at: $phpmailerPath");
            return false;
        }
        
        // Include PHPMailer classes
        require_once $phpmailerPath . 'Exception.php';
        require_once $phpmailerPath . 'PHPMailer.php';
        require_once $phpmailerPath . 'SMTP.php';
        
        // Check if PHPMailer class exists
        if (!class_exists('PHPMailer\PHPMailer\PHPMailer')) {
            error_log("PHPMailer class not found after including files");
            return false;
        }
        
        $mail = new PHPMailer\PHPMailer\PHPMailer(true);
        
        // Disable debug mode for production
        $mail->SMTPDebug = 0;
        $mail->Debugoutput = 'error_log';
        
        // Server settings
        $mail->isSMTP();
        $mail->Host = SMTP_HOST;
        $mail->SMTPAuth = true;
        $mail->Username = SMTP_USERNAME;
        $mail->Password = SMTP_PASSWORD;
        $mail->SMTPSecure = SMTP_SECURE;
        $mail->Port = SMTP_PORT;
        $mail->CharSet = 'UTF-8';
        
        // Set timeout
        $mail->Timeout = 30;
        $mail->SMTPKeepAlive = false;
        
        // Recipients
        $mail->setFrom(SMTP_FROM_EMAIL, SMTP_FROM_NAME);
        $mail->addAddress($to);
        
        if (!empty($replyTo)) {
            $mail->addReplyTo($replyTo);
        }
        
        // Content
        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body = $message;
        $mail->AltBody = strip_tags($message);
        
        // Send email
        $result = $mail->send();
        
        if ($result) {
            error_log("Email sent successfully via SMTP to: $to");
            return true;
        } else {
            error_log("Failed to send email via SMTP to: $to");
            return false;
        }
        
    } catch (Exception $e) {
        error_log("SMTP Error: " . $e->getMessage());
        return false;
    }
}

// Send email with fallback and improved error handling
function sendEmailWithFallback($to, $subject, $message, $replyTo = '') {
    error_log("Attempting to send email to: $to");
    
    // Try SMTP first
    if (SMTP_ENABLED) {
        error_log("Trying SMTP method...");
        $result = sendEmailSMTP($to, $subject, $message, $replyTo);
        if ($result) {
            error_log("Email sent successfully via SMTP");
            return true;
        } else {
            error_log("SMTP failed, trying fallback method...");
        }
    }
    
    // Fallback to PHP mail function
    error_log("Trying PHP mail() function...");
    $headers = "MIME-Version: 1.0\r\n";
    $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
    $headers .= "From: " . SMTP_FROM_NAME . " <" . SMTP_FROM_EMAIL . ">\r\n";
    
    if (!empty($replyTo)) {
        $headers .= "Reply-To: $replyTo\r\n";
    }
    
    $result = mail($to, $subject, $message, $headers);
    
    if ($result) {
        error_log("Email sent successfully via PHP mail()");
        return true;
    } else {
        error_log("Failed to send email via PHP mail()");
        return false;
    }
}


?>
