<?php
// Get current page for active state
$current_page = basename($_SERVER['PHP_SELF']);
?>

<!-- Glassmorphism Sidebar -->
<aside class="glassmorphism-sidebar" id="sidebar">
    <div class="sidebar-header">
        <div class="sidebar-logo">
            <img src="assets/images/logo.png" alt="گواهیتو" class="logo-image">
            <span class="logo-text">گواهیتو</span>
        </div>
        <button class="sidebar-close" id="sidebarClose">
            <span>×</span>
        </button>
    </div>
    
    <nav class="sidebar-nav">
        <ul class="sidebar-menu">
            <li class="sidebar-item <?php echo ($current_page === 'dashboard.php') ? 'active' : ''; ?>">
                <a href="dashboard.php" class="sidebar-link">
                    <span class="sidebar-icon">📊</span>
                    <span class="sidebar-text">داشبورد</span>
                </a>
            </li>
            <li class="sidebar-item <?php echo ($current_page === 'users.php') ? 'active' : ''; ?>">
                <a href="users.php" class="sidebar-link">
                    <span class="sidebar-icon">👥</span>
                    <span class="sidebar-text">کاربران</span>
                </a>
            </li>
            <li class="sidebar-item <?php echo ($current_page === 'bug-reports.php') ? 'active' : ''; ?>">
                <a href="bug-reports.php" class="sidebar-link">
                    <span class="sidebar-icon">🐛</span>
                    <span class="sidebar-text">گزارش باگ</span>
                    <?php if (isset($stats['new_bugs']) && $stats['new_bugs'] > 0): ?>
                        <span class="sidebar-badge"><?php echo $stats['new_bugs']; ?></span>
                    <?php endif; ?>
                </a>
            </li>
            <li class="sidebar-item <?php echo ($current_page === 'feature-requests.php') ? 'active' : ''; ?>">
                <a href="feature-requests.php" class="sidebar-link">
                    <span class="sidebar-icon">✨</span>
                    <span class="sidebar-text">درخواست ویژگی</span>
                    <?php if (isset($stats['new_features']) && $stats['new_features'] > 0): ?>
                        <span class="sidebar-badge"><?php echo $stats['new_features']; ?></span>
                    <?php endif; ?>
                </a>
            </li>
            <li class="sidebar-item <?php echo ($current_page === 'security.php') ? 'active' : ''; ?>">
                <a href="security.php" class="sidebar-link">
                    <span class="sidebar-icon">🔒</span>
                    <span class="sidebar-text">امنیت</span>
                    <?php if (isset($stats['security_events']) && $stats['security_events'] > 0): ?>
                        <span class="sidebar-badge warning"><?php echo $stats['security_events']; ?></span>
                    <?php endif; ?>
                </a>
            </li>
            <li class="sidebar-item <?php echo ($current_page === 'ip-management.php') ? 'active' : ''; ?>">
                <a href="ip-management.php" class="sidebar-link">
                    <span class="sidebar-icon">🌐</span>
                    <span class="sidebar-text">مدیریت IP</span>
                </a>
            </li>
                         <li class="sidebar-item <?php echo ($current_page === 'threat-detection.php') ? 'active' : ''; ?>">
                 <a href="threat-detection.php" class="sidebar-link">
                     <span class="sidebar-icon">🛡️</span>
                     <span class="sidebar-text">تشخیص تهدید</span>
                     <?php
                     // Only show threat count on threat-detection page
                     if ($current_page === 'threat-detection.php' && isset($threatStats['unique_threat_ips']) && $threatStats['unique_threat_ips'] > 0): ?>
                         <span class="sidebar-badge danger"><?php echo $threatStats['unique_threat_ips']; ?></span>
                     <?php endif; ?>
                 </a>
             </li>
            <li class="sidebar-item <?php echo ($current_page === 'settings.php') ? 'active' : ''; ?>">
                <a href="settings.php" class="sidebar-link">
                    <span class="sidebar-icon">⚙️</span>
                    <span class="sidebar-text">تنظیمات</span>
                </a>
            </li>
            <li class="sidebar-item <?php echo ($current_page === 'backups.php') ? 'active' : ''; ?>">
                <a href="backups.php" class="sidebar-link">
                    <span class="sidebar-icon">📦</span>
                    <span class="sidebar-text">بکاپ‌ها</span>
                </a>
            </li>
        </ul>
    </nav>
    
    <div class="sidebar-footer">
        <div class="user-profile">
            <div class="user-avatar">
                <span>👤</span>
            </div>
            <div class="user-details">
                <div class="user-name"><?php echo htmlspecialchars($_SESSION['admin_username']); ?></div>
                <div class="user-role">مدیر سیستم</div>
            </div>
        </div>
    </div>
</aside>
