<?php
// Start output buffering to prevent any output before headers
ob_start();

// Start session first (before any output)
if (session_status() === PHP_SESSION_NONE) {
    @session_start();
}

// Prevent direct access after installation
if (file_exists(__DIR__ . '/install.lock')) {
    ob_end_clean();
    header('Location: dashboard.php');
    exit;
}

// Set proper charset headers
header('Content-Type: text/html; charset=utf-8');
mb_internal_encoding('UTF-8');
mb_http_output('UTF-8');

$error = '';
$success = false;
$step = isset($_POST['step']) ? (int)$_POST['step'] : 0;
$install_type = isset($_POST['install_type']) ? $_POST['install_type'] : (isset($_SESSION['install_type']) ? $_SESSION['install_type'] : '');
$db_connection = null;
$db_host = '';
$db_name = '';
$db_user = '';
$db_pass = '';

// Step 0: Choose installation type
if ($step === 0 && $_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['install_type'])) {
    $install_type = $_POST['install_type'];
    $_SESSION['install_type'] = $install_type;
    
    if ($install_type === 'install') {
        $step = 1; // Go to database connection step
    } elseif ($install_type === 'update') {
        $step = 1; // Go to database connection step (update mode)
    }
}

// Step 1: Test database connection
if ($step === 1 && $_SERVER['REQUEST_METHOD'] === 'POST') {
    $install_type = $_SESSION['install_type'] ?? 'install';
    
    $db_host = trim($_POST['db_host'] ?? 'localhost');
    $db_name = trim($_POST['db_name'] ?? '');
    $db_user = trim($_POST['db_user'] ?? '');
    $db_pass = trim($_POST['db_pass'] ?? '');
    
    // Validation
    if (empty($db_host) || empty($db_name) || empty($db_user)) {
        $error = 'لطفاً تمام فیلدهای الزامی را پر کنید';
    } else {
        try {
            // Connect to MySQL server (without database)
            $pdo = new PDO(
                "mysql:host={$db_host};charset=utf8mb4",
                $db_user,
                $db_pass,
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::MYSQL_ATTR_USE_BUFFERED_QUERY => true
                ]
            );
            
            // Test connection
            $pdo->query("SELECT 1")->fetchAll();
            
            // Check if database exists
            $stmt = $pdo->query("SHOW DATABASES LIKE '{$db_name}'");
            $dbExists = $stmt->fetchAll();
            $stmt->closeCursor();
            
            // If update mode, verify database exists
            if ($install_type === 'update') {
                if (empty($dbExists)) {
                    throw new Exception("دیتابیس '{$db_name}' یافت نشد. لطفاً نام دیتابیس موجود را وارد کنید.");
                }
                
                // Test connection to the database
                $testPdo = new PDO(
                    "mysql:host={$db_host};dbname={$db_name};charset=utf8mb4",
                    $db_user,
                    $db_pass,
                    [
                        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                        PDO::MYSQL_ATTR_USE_BUFFERED_QUERY => true
                    ]
                );
                $testPdo->query("SELECT 1")->fetchAll();
                $testPdo = null;
            }
            
            // Store connection info in session for next step
            $_SESSION['install_db_host'] = $db_host;
            $_SESSION['install_db_name'] = $db_name;
            $_SESSION['install_db_user'] = $db_user;
            $_SESSION['install_db_pass'] = $db_pass;
            
            // If update mode, save config and redirect
            if ($install_type === 'update') {
                // Save database config
                $configDir = __DIR__ . '/config';
                if (!is_dir($configDir)) {
                    mkdir($configDir, 0755, true);
                }
                
                $configContent = "<?php\n";
                $configContent .= "// Database configuration\n";
                $configContent .= "// This file is auto-generated by install.php\n\n";
                $configContent .= "class Database {\n";
                $configContent .= "    public \$host = '" . addslashes($db_host) . "';\n";
                $configContent .= "    public \$database = '" . addslashes($db_name) . "';\n";
                $configContent .= "    public \$username = '" . addslashes($db_user) . "';\n";
                $configContent .= "    public \$password = '" . addslashes($db_pass) . "';\n";
                $configContent .= "    private \$conn;\n\n";
                $configContent .= "    public function getConnection() {\n";
                $configContent .= "        \$this->conn = null;\n";
                $configContent .= "        try {\n";
                $configContent .= "            \$this->conn = new PDO(\n";
                $configContent .= "                \"mysql:host=\" . \$this->host . \";dbname=\" . \$this->database . \";charset=utf8mb4\",\n";
                $configContent .= "                \$this->username,\n";
                $configContent .= "                \$this->password,\n";
                $configContent .= "                [\n";
                $configContent .= "                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,\n";
                $configContent .= "                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,\n";
                $configContent .= "                    PDO::MYSQL_ATTR_USE_BUFFERED_QUERY => true\n";
                $configContent .= "                ]\n";
                $configContent .= "            );\n";
                $configContent .= "        } catch(PDOException \$e) {\n";
                $configContent .= "            error_log(\"Connection error: \" . \$e->getMessage());\n";
                $configContent .= "        }\n";
                $configContent .= "        return \$this->conn;\n";
                $configContent .= "    }\n";
                $configContent .= "}\n";
                
                file_put_contents($configDir . '/database.php', $configContent);
                
                // Create install.lock
                file_put_contents(__DIR__ . '/install.lock', date('Y-m-d H:i:s'));
                
                // Clear session
                session_destroy();
                
                // Redirect to dashboard
                header('Location: dashboard.php');
                exit;
            } else {
                // Move to step 2 for fresh installation
                $step = 2;
            }
            
        } catch (PDOException $e) {
            $error = 'خطا در اتصال به دیتابیس: ' . $e->getMessage();
        } catch (Exception $e) {
            $error = $e->getMessage();
        }
    }
}

// Step 2: Drop all tables and install fresh database
if ($step === 2 && $_SERVER['REQUEST_METHOD'] === 'POST') {
    $db_host = $_SESSION['install_db_host'] ?? '';
    $db_name = $_SESSION['install_db_name'] ?? '';
    $db_user = $_SESSION['install_db_user'] ?? '';
    $db_pass = $_SESSION['install_db_pass'] ?? '';
    
    $admin_username = trim($_POST['admin_username'] ?? '');
    $admin_password = trim($_POST['admin_password'] ?? '');
    $admin_email = trim($_POST['admin_email'] ?? '');
    
    // Validation
    if (empty($db_host) || empty($db_name) || empty($db_user)) {
        $error = 'اطلاعات دیتابیس یافت نشد. لطفاً از ابتدا شروع کنید.';
        $step = 1;
    } elseif (empty($admin_username) || empty($admin_password)) {
        $error = 'لطفاً اطلاعات مدیر را وارد کنید';
    } elseif (strlen($admin_password) < 8) {
        $error = 'رمز عبور باید حداقل 8 کاراکتر باشد';
    } elseif (!empty($admin_email) && !filter_var($admin_email, FILTER_VALIDATE_EMAIL)) {
        $error = 'ایمیل وارد شده معتبر نیست';
    } else {
        try {
            // Connect to MySQL server
            $pdo = new PDO(
                "mysql:host={$db_host};charset=utf8mb4",
                $db_user,
                $db_pass,
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::MYSQL_ATTR_USE_BUFFERED_QUERY => true,
                    PDO::ATTR_EMULATE_PREPARES => false
                ]
            );
            
            // Drop database if exists (this will delete all tables)
            $dropStmt = $pdo->prepare("DROP DATABASE IF EXISTS `{$db_name}`");
            $dropStmt->execute();
            $dropStmt->closeCursor();
            
            // Create fresh database
            $createStmt = $pdo->prepare("CREATE DATABASE `{$db_name}` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
            $createStmt->execute();
            $createStmt->closeCursor();
            
            // Close connection and reconnect to the new database
            $pdo = null;
            $pdo = new PDO(
                "mysql:host={$db_host};dbname={$db_name};charset=utf8mb4",
                $db_user,
                $db_pass,
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::MYSQL_ATTR_USE_BUFFERED_QUERY => true,
                    PDO::ATTR_EMULATE_PREPARES => false
                ]
            );
            
            // Disable foreign key checks temporarily
            $fkStmt = $pdo->prepare("SET FOREIGN_KEY_CHECKS = 0");
            $fkStmt->execute();
            $fkStmt->closeCursor();
            
            // Read and execute schema.sql
            $schemaFile = __DIR__ . '/database/schema.sql';
            if (!file_exists($schemaFile)) {
                throw new Exception('فایل schema.sql یافت نشد');
            }
            
            $schema = file_get_contents($schemaFile);
            // Remove USE statement and comments
            $schema = preg_replace('/USE\s+`[^`]+`;/i', '', $schema);
            $schema = preg_replace('/--.*$/m', '', $schema);
            $schema = preg_replace('/\/\*.*?\*\//s', '', $schema);
            
            // Split by semicolon and execute each statement
            $statements = array_filter(array_map('trim', explode(';', $schema)));
            foreach ($statements as $statement) {
                if (!empty($statement) && strlen($statement) > 10) {
                    try {
                        // Use prepare and execute for better handling
                        $stmt = $pdo->prepare($statement);
                        $stmt->execute();
                        $stmt->closeCursor();
                    } catch (PDOException $e) {
                        // Only ignore duplicate table errors, throw others
                        if (strpos($e->getMessage(), 'already exists') === false &&
                            strpos($e->getMessage(), 'Duplicate') === false) {
                            throw $e;
                        }
                    }
                }
            }
            
            // Execute create-essential-tables.sql
            $essentialTablesFile = __DIR__ . '/sql/create-essential-tables.sql';
            if (file_exists($essentialTablesFile)) {
                $essentialSchema = file_get_contents($essentialTablesFile);
                $essentialSchema = preg_replace('/--.*$/m', '', $essentialSchema);
                $essentialSchema = preg_replace('/\/\*.*?\*\//s', '', $essentialSchema);
                $essentialStatements = array_filter(array_map('trim', explode(';', $essentialSchema)));
                foreach ($essentialStatements as $statement) {
                    if (!empty($statement) && strlen($statement) > 10) {
                        try {
                            $stmt = $pdo->prepare($statement);
                            $stmt->execute();
                            $stmt->closeCursor();
                        } catch (PDOException $e) {
                            if (strpos($e->getMessage(), 'already exists') === false && 
                                strpos($e->getMessage(), 'Duplicate entry') === false &&
                                strpos($e->getMessage(), 'Duplicate') === false) {
                                error_log("Table creation warning: " . $e->getMessage());
                            }
                        }
                    }
                }
            }
            
            // Execute create-system-settings.sql
            $systemSettingsFile = __DIR__ . '/sql/create-system-settings.sql';
            if (file_exists($systemSettingsFile)) {
                $systemSettingsSchema = file_get_contents($systemSettingsFile);
                $systemSettingsSchema = preg_replace('/--.*$/m', '', $systemSettingsSchema);
                $systemSettingsSchema = preg_replace('/\/\*.*?\*\//s', '', $systemSettingsSchema);
                $systemSettingsStatements = array_filter(array_map('trim', explode(';', $systemSettingsSchema)));
                foreach ($systemSettingsStatements as $statement) {
                    if (!empty($statement) && strlen($statement) > 10) {
                        try {
                            $stmt = $pdo->prepare($statement);
                            $stmt->execute();
                            $stmt->closeCursor();
                        } catch (PDOException $e) {
                            if (strpos($e->getMessage(), 'already exists') === false && 
                                strpos($e->getMessage(), 'Duplicate entry') === false &&
                                strpos($e->getMessage(), 'Duplicate key') === false &&
                                strpos($e->getMessage(), 'Duplicate') === false) {
                                error_log("System settings creation warning: " . $e->getMessage());
                            }
                        }
                    }
                }
            }
            
            // Execute fix-security-tables.sql
            $securityTablesFile = __DIR__ . '/sql/fix-security-tables.sql';
            if (file_exists($securityTablesFile)) {
                $securitySchema = file_get_contents($securityTablesFile);
                $securitySchema = preg_replace('/--.*$/m', '', $securitySchema);
                $securitySchema = preg_replace('/\/\*.*?\*\//s', '', $securitySchema);
                $securityStatements = array_filter(array_map('trim', explode(';', $securitySchema)));
                foreach ($securityStatements as $statement) {
                    if (!empty($statement) && strlen($statement) > 10) {
                        try {
                            $stmt = $pdo->prepare($statement);
                            $stmt->execute();
                            $stmt->closeCursor();
                        } catch (PDOException $e) {
                            if (strpos($e->getMessage(), 'already exists') === false && 
                                strpos($e->getMessage(), 'Duplicate entry') === false &&
                                strpos($e->getMessage(), 'Duplicate key') === false &&
                                strpos($e->getMessage(), 'Duplicate') === false) {
                                error_log("Security tables creation warning: " . $e->getMessage());
                            }
                        }
                    }
                }
            }
            
            // Execute fix-verification-codes-table.sql
            $verificationCodesFile = __DIR__ . '/sql/fix-verification-codes-table.sql';
            if (file_exists($verificationCodesFile)) {
                $verificationSchema = file_get_contents($verificationCodesFile);
                $verificationSchema = preg_replace('/--.*$/m', '', $verificationSchema);
                $verificationSchema = preg_replace('/\/\*.*?\*\//s', '', $verificationSchema);
                $verificationStatements = array_filter(array_map('trim', explode(';', $verificationSchema)));
                foreach ($verificationStatements as $statement) {
                    if (!empty($statement) && strlen($statement) > 10) {
                        try {
                            $stmt = $pdo->prepare($statement);
                            $stmt->execute();
                            $stmt->closeCursor();
                        } catch (PDOException $e) {
                            // Ignore errors for ALTER TABLE if column already exists or has correct type
                            if (strpos($e->getMessage(), 'Duplicate column') === false &&
                                strpos($e->getMessage(), 'already exists') === false &&
                                strpos($e->getMessage(), 'Duplicate key') === false) {
                                error_log("Verification codes table fix warning: " . $e->getMessage());
                            }
                        }
                    }
                }
            }
            
            // Delete related data first (while foreign keys are disabled)
            // Get admin user IDs first
            try {
                $getAdminIdsStmt = $pdo->prepare("SELECT id FROM admin_users WHERE username IN ('raytheme', 'admin')");
                $getAdminIdsStmt->execute();
                $adminIds = $getAdminIdsStmt->fetchAll(PDO::FETCH_COLUMN);
                $getAdminIdsStmt->closeCursor();
                
                // Delete from all tables that reference admin_users
                if (!empty($adminIds)) {
                    $placeholders = implode(',', array_fill(0, count($adminIds), '?'));
                    
                    // Delete from ip_whitelist
                    try {
                        $deleteWhitelistStmt = $pdo->prepare("DELETE FROM ip_whitelist WHERE added_by IN ($placeholders)");
                        $deleteWhitelistStmt->execute($adminIds);
                        $deleteWhitelistStmt->closeCursor();
                    } catch (PDOException $e) {
                        // Ignore if table doesn't exist
                    }
                    
                    // Delete from ip_blacklist
                    try {
                        $deleteBlacklistStmt = $pdo->prepare("DELETE FROM ip_blacklist WHERE added_by IN ($placeholders)");
                        $deleteBlacklistStmt->execute($adminIds);
                        $deleteBlacklistStmt->closeCursor();
                    } catch (PDOException $e) {
                        // Ignore if table doesn't exist
                    }
                    
                    // Delete from backups (created_by)
                    try {
                        $deleteBackupsStmt = $pdo->prepare("DELETE FROM backups WHERE created_by IN ($placeholders)");
                        $deleteBackupsStmt->execute($adminIds);
                        $deleteBackupsStmt->closeCursor();
                    } catch (PDOException $e) {
                        // Ignore if table doesn't exist
                    }
                    
                    // verification_codes has ON DELETE CASCADE, so it will be deleted automatically
                }
            } catch (PDOException $e) {
                // Ignore if admin_users table doesn't exist yet
            }
            
            // Delete any default admin users (while foreign keys are disabled)
            try {
                $deleteStmt = $pdo->prepare("DELETE FROM admin_users WHERE username IN ('raytheme', 'admin')");
                $deleteStmt->execute();
                $deleteStmt->closeCursor();
            } catch (PDOException $e) {
                // Ignore if no users to delete
            }
            
            // Re-enable foreign key checks
            $fkStmt = $pdo->prepare("SET FOREIGN_KEY_CHECKS = 1");
            $fkStmt->execute();
            $fkStmt->closeCursor();
            
            // Create admin user
            $passwordHash = password_hash($admin_password, PASSWORD_ARGON2ID, [
                'memory_cost' => 131072,
                'time_cost' => 8,
                'threads' => 4
            ]);
            
            $stmt = $pdo->prepare("INSERT INTO admin_users (username, password, email, is_active, is_protected, created_at) VALUES (?, ?, ?, 1, 1, NOW())");
            $stmt->execute([$admin_username, $passwordHash, $admin_email ?: null]);
            $stmt->closeCursor();
            
            // Insert/Update system settings
            $settings = [
                ['rate_limit_per_hour', '5'],
                ['session_timeout_minutes', '30'],
                ['enable_xss_protection', '1'],
                ['enable_sql_injection_protection', '1'],
                ['enable_recaptcha', '1'],
                ['site_name', 'گواهیتو Admin Panel'],
                ['site_url', (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . dirname(dirname($_SERVER['SCRIPT_NAME']))],
                ['admin_email', $admin_email ?: ''],
                ['email_from', $admin_email ?: ''],
                ['email_from_name', 'گواهیتو Security System'],
                ['maintenance_mode', '0'],
                ['maintenance_message', 'سیستم در حال نگهداری است. لطفاً کمی صبر کنید.'],
                ['backup_enabled', '0'],
                ['backup_frequency', 'daily'],
                ['log_retention_days', '30'],
                ['max_login_attempts', '5'],
                ['lockout_duration_minutes', '15'],
                ['password_min_length', '8'],
                ['require_strong_password', '1'],
                ['twofa_enabled', '0'],
                ['twofa_code_expiry', '300'],
                ['email_notifications', '1'],
                ['auto_logout_minutes', '30'],
                ['favicon_path', 'assets/favicons/favicon.ico'],
                ['email_alerts', '1'],
                ['email_recipient', $admin_email ?: ''],
                ['email_alert_level', 'medium'],
                ['email_frequency', 'immediate']
            ];
            
            $stmt = $pdo->prepare("INSERT INTO system_settings (setting_key, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)");
            foreach ($settings as $setting) {
                $stmt->execute($setting);
            }
            $stmt->closeCursor();
            
            // Create database config file
            $configContent = "<?php
class Database {
    public \$host = \"{$db_host}\";
    public \$database = \"{$db_name}\";
    public \$username = \"{$db_user}\";
    public \$password = \"" . addslashes($db_pass) . "\";
    private \$conn;

    public function getConnection() {
        \$this->conn = null;

        try {
            \$this->conn = new PDO(
                \"mysql:host=\" . \$this->host . \";dbname=\" . \$this->database . \";charset=utf8mb4\",
                \$this->username,
                \$this->password,
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES => false
                ]
            );
            
            // Set charset explicitly after connection
            \$this->conn->exec(\"SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci\");
            \$this->conn->exec(\"SET CHARACTER SET utf8mb4\");
            \$this->conn->exec(\"SET character_set_connection=utf8mb4\");
            
        } catch(PDOException \$exception) {
            error_log(\"Connection error: \" . \$exception->getMessage());
            throw new Exception(\"خطا در اتصال به دیتابیس\");
        }

        return \$this->conn;
    }
}
?>";
            
            file_put_contents(__DIR__ . '/config/database.php', $configContent);
            
            // Create install lock file
            file_put_contents(__DIR__ . '/install.lock', date('Y-m-d H:i:s'));
            
            // Clear session
            session_destroy();
            
            $success = true;
            
        } catch (PDOException $e) {
            $error = 'خطا در نصب دیتابیس: ' . $e->getMessage();
        } catch (Exception $e) {
            $error = $e->getMessage();
        }
    }
}

// Get values from session if available
$install_type = $_SESSION['install_type'] ?? 'install';
if ($step === 2 && !isset($_POST['step'])) {
    $db_host = $_SESSION['install_db_host'] ?? '';
    $db_name = $_SESSION['install_db_name'] ?? '';
    $db_user = $_SESSION['install_db_user'] ?? '';
    $db_pass = $_SESSION['install_db_pass'] ?? '';
} elseif ($step === 1 && !isset($_POST['step'])) {
    $db_host = $_SESSION['install_db_host'] ?? '';
    $db_name = $_SESSION['install_db_name'] ?? '';
    $db_user = $_SESSION['install_db_user'] ?? '';
    $db_pass = $_SESSION['install_db_pass'] ?? '';
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>نصب گواهیتو - پنل مدیریت</title>
    <link rel="icon" type="image/png" href="assets/images/logo.png">
    <link rel="stylesheet" href="assets/admin-style.css">
    <?php 
    // Include admin styles if file exists
    try {
        if (file_exists(__DIR__ . '/includes/admin-styles.php')) {
            ob_start();
            include __DIR__ . '/includes/admin-styles.php';
            ob_end_flush();
        } else {
            // Fallback styles
            echo '<style>@import url(\'https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700&display=swap\');</style>';
        }
    } catch (Exception $e) {
        // Fallback styles if include fails
        echo '<style>@import url(\'https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700&display=swap\');</style>';
    }
    ?>
    <style>
        .install-container {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 2rem;
            background: linear-gradient(135deg, #041c3f 0%, #022847 50%, #041c3f 100%);
        }
        
        .install-card {
            background: linear-gradient(135deg, #041c3f 0%, #022847 100%);
            border-radius: 1.5rem;
            padding: 3rem;
            max-width: 600px;
            width: 100%;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            border: 1px solid rgba(197, 145, 44, 0.2);
        }
        
        .install-header {
            text-align: center;
            margin-bottom: 2rem;
        }
        
        .install-logo {
            width: 80px;
            height: 80px;
            margin: 0 auto 1.5rem;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 1rem;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 1rem;
        }
        
        .install-logo img {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }
        
        .install-title {
            font-size: 2rem;
            font-weight: 700;
            color: #c5912c;
            margin-bottom: 0.5rem;
        }
        
        .install-subtitle {
            color: rgba(255, 255, 255, 0.8);
            font-size: 1.1rem;
        }
        
        .install-steps {
            display: flex;
            justify-content: space-between;
            margin-bottom: 2rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid rgba(197, 145, 44, 0.2);
        }
        
        .step {
            flex: 1;
            text-align: center;
            position: relative;
        }
        
        .step::after {
            content: '';
            position: absolute;
            top: 15px;
            right: 50%;
            width: 100%;
            height: 2px;
            background: rgba(197, 145, 44, 0.3);
            z-index: 0;
        }
        
        .step:last-child::after {
            display: none;
        }
        
        .step-number {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background: rgba(197, 145, 44, 0.2);
            color: #c5912c;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 0.5rem;
            font-weight: 600;
            position: relative;
            z-index: 1;
        }
        
        .step.active .step-number {
            background: #c5912c;
            color: white;
        }
        
        .step.completed .step-number {
            background: #059669;
            color: white;
        }
        
        .step-label {
            font-size: 0.875rem;
            color: rgba(255, 255, 255, 0.6);
        }
        
        .step.active .step-label {
            color: #c5912c;
        }
        
        .form-group {
            margin-bottom: 1.5rem;
        }
        
        .form-label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 500;
            color: rgba(255, 255, 255, 0.9);
        }
        
        .form-input {
            width: 100%;
            padding: 0.75rem 1rem;
            border: 1px solid rgba(197, 145, 44, 0.3);
            border-radius: 0.5rem;
            background: rgba(4, 28, 63, 0.5);
            color: white;
            font-family: 'Vazirmatn', sans-serif;
            transition: all 0.3s ease;
        }
        
        .form-input:focus {
            outline: none;
            border-color: #c5912c;
            box-shadow: 0 0 0 3px rgba(197, 145, 44, 0.1);
            background: rgba(4, 28, 63, 0.7);
        }
        
        .form-input::placeholder {
            color: rgba(255, 255, 255, 0.4);
        }
        
        .alert {
            padding: 1rem 1.5rem;
            border-radius: 0.5rem;
            margin-bottom: 1.5rem;
            border: 1px solid transparent;
        }
        
        .alert-danger {
            background: rgba(220, 38, 38, 0.2);
            color: #fca5a5;
            border-color: rgba(220, 38, 38, 0.3);
        }
        
        .alert-success {
            background: rgba(5, 150, 105, 0.2);
            color: #6ee7b7;
            border-color: rgba(5, 150, 105, 0.3);
        }
        
        .alert-info {
            background: rgba(59, 130, 246, 0.2);
            color: #93c5fd;
            border-color: rgba(59, 130, 246, 0.3);
        }
        
        .btn-install {
            width: 100%;
            padding: 1rem;
            background: linear-gradient(135deg, #c5912c 0%, #b08226 100%);
            color: white;
            border: none;
            border-radius: 0.5rem;
            font-size: 1.1rem;
            font-weight: 600;
            font-family: 'Vazirmatn', sans-serif;
            cursor: pointer;
            transition: all 0.3s ease;
            margin-top: 1rem;
        }
        
        .btn-install:hover {
            background: linear-gradient(135deg, #b08226 0%, #9a6f20 100%);
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(197, 145, 44, 0.3);
        }
        
        .btn-install:disabled {
            opacity: 0.6;
            cursor: not-allowed;
        }
        
        .success-message {
            text-align: center;
            padding: 2rem;
        }
        
        .success-icon {
            font-size: 4rem;
            margin-bottom: 1rem;
        }
        
        .success-title {
            font-size: 1.5rem;
            color: #c5912c;
            margin-bottom: 1rem;
        }
        
        .success-text {
            color: rgba(255, 255, 255, 0.8);
            margin-bottom: 2rem;
        }
        
        .btn-success {
            display: inline-block;
            padding: 0.75rem 2rem;
            background: linear-gradient(135deg, #c5912c 0%, #b08226 100%);
            color: white;
            text-decoration: none;
            border-radius: 0.5rem;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-success:hover {
            background: linear-gradient(135deg, #b08226 0%, #9a6f20 100%);
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(197, 145, 44, 0.3);
        }
        
        .info-text {
            font-size: 0.875rem;
            color: rgba(255, 255, 255, 0.6);
            margin-top: 0.5rem;
        }
        
        .db-info {
            background: rgba(59, 130, 246, 0.1);
            border: 1px solid rgba(59, 130, 246, 0.3);
            border-radius: 0.5rem;
            padding: 1rem;
            margin-bottom: 1.5rem;
        }
        
        .db-info-item {
            display: flex;
            justify-content: space-between;
            margin-bottom: 0.5rem;
            color: rgba(255, 255, 255, 0.8);
        }
        
        .db-info-label {
            font-weight: 600;
            color: #93c5fd;
        }
    </style>
</head>
<body>
    <div class="install-container">
        <div class="install-card">
            <div class="install-header">
                <div class="install-logo">
                    <img src="assets/images/logo.png" alt="گواهیتو">
                </div>
                <h1 class="install-title">نصب گواهیتو</h1>
                <p class="install-subtitle">پنل مدیریت سیستم</p>
            </div>
            
            <?php if ($step > 0): ?>
            <div class="install-steps">
                <div class="step <?php echo $step >= 1 ? 'active' : ''; ?> <?php echo $step > 1 ? 'completed' : ''; ?>">
                    <div class="step-number">1</div>
                    <div class="step-label">تست اتصال</div>
                </div>
                <?php if ($install_type === 'install'): ?>
                <div class="step <?php echo $step >= 2 ? 'active' : ''; ?> <?php echo $success ? 'completed' : ''; ?>">
                    <div class="step-number">2</div>
                    <div class="step-label">نصب دیتابیس</div>
                </div>
                <div class="step <?php echo $success ? 'completed' : ''; ?>">
                    <div class="step-number">3</div>
                    <div class="step-label">تکمیل</div>
                </div>
                <?php else: ?>
                <div class="step <?php echo $success ? 'completed' : ''; ?>">
                    <div class="step-number">2</div>
                    <div class="step-label">تکمیل</div>
                </div>
                <?php endif; ?>
            </div>
            <?php endif; ?>
            
            <?php if ($error): ?>
                <div class="alert alert-danger">
                    <?php echo htmlspecialchars($error); ?>
                </div>
            <?php endif; ?>
            
            <?php if ($success): ?>
                <div class="success-message">
                    <div class="success-icon">✅</div>
                    <h2 class="success-title">نصب با موفقیت انجام شد!</h2>
                    <p class="success-text">
                        سیستم گواهیتو با موفقیت نصب شد. دیتابیس به صورت کامل پاک و دوباره ایجاد شد.
                    </p>
                    <a href="hf8fAS7wkd99iudu8.php" class="btn-success">ورود به پنل مدیریت</a>
                </div>
            <?php else: ?>
                <?php if ($step === 0): ?>
                <div style="text-align: center;">
                    <h3 style="color: #c5912c; margin-bottom: 2rem; font-size: 1.5rem;">نوع نصب را انتخاب کنید</h3>
                    
                    <form method="POST" action="" style="display: flex; flex-direction: column; gap: 1.5rem;">
                        <input type="hidden" name="step" value="0">
                        
                        <button type="submit" name="install_type" value="install" 
                                style="padding: 1.5rem; background: linear-gradient(135deg, #c5912c 0%, #b08226 100%); 
                                       color: white; border: none; border-radius: 0.75rem; font-size: 1.1rem; 
                                       font-weight: 600; cursor: pointer; transition: all 0.3s ease;">
                            <div style="font-size: 2rem; margin-bottom: 0.5rem;">🆕</div>
                            <div style="font-size: 1.25rem; margin-bottom: 0.5rem;">نصب جدید</div>
                            <div style="font-size: 0.9rem; opacity: 0.9;">نصب کامل سیستم با ایجاد دیتابیس جدید</div>
                        </button>
                        
                        <button type="submit" name="install_type" value="update" 
                                style="padding: 1.5rem; background: linear-gradient(135deg, #041c3f 0%, #022847 100%); 
                                       color: #c5912c; border: 2px solid #c5912c; border-radius: 0.75rem; 
                                       font-size: 1.1rem; font-weight: 600; cursor: pointer; transition: all 0.3s ease;">
                            <div style="font-size: 2rem; margin-bottom: 0.5rem;">🔄</div>
                            <div style="font-size: 1.25rem; margin-bottom: 0.5rem;">اپدیت</div>
                            <div style="font-size: 0.9rem; opacity: 0.9;">فقط اتصال به دیتابیس موجود (بدون تغییر داده‌ها)</div>
                        </button>
                    </form>
                </div>
            <?php elseif ($step === 1): ?>
                <form method="POST" action="">
                    <input type="hidden" name="step" value="1">
                    
                    <h3 style="color: #c5912c; margin-bottom: 1.5rem; font-size: 1.25rem;">اطلاعات دیتابیس</h3>
                    
                    <?php if ($install_type === 'update'): ?>
                        <div class="alert alert-info">
                            <strong>حالت اپدیت:</strong> فقط اطلاعات اتصال به دیتابیس ذخیره می‌شود. هیچ داده‌ای تغییر یا حذف نمی‌شود.
                        </div>
                    <?php else: ?>
                        <div class="alert alert-info">
                            <strong>توجه:</strong> در این مرحله فقط اتصال به دیتابیس تست می‌شود. در مرحله بعدی دیتابیس به صورت کامل پاک و دوباره ایجاد می‌شود.
                        </div>
                    <?php endif; ?>
                    
                    <div class="form-group">
                        <label for="db_host" class="form-label">آدرس سرور دیتابیس *</label>
                        <input type="text" id="db_host" name="db_host" class="form-input" 
                               value="<?php echo htmlspecialchars($db_host ?: 'localhost'); ?>" 
                               placeholder="localhost" required>
                        <div class="info-text">معمولاً localhost است</div>
                    </div>
                    
                    <div class="form-group">
                        <label for="db_name" class="form-label">نام دیتابیس *</label>
                        <input type="text" id="db_name" name="db_name" class="form-input" 
                               value="<?php echo htmlspecialchars($db_name); ?>" 
                               placeholder="نام دیتابیس" required>
                        <div class="info-text">
                            <?php echo $install_type === 'update' ? 'نام دیتابیس موجود را وارد کنید' : 'دیتابیس به صورت خودکار ایجاد می‌شود'; ?>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label for="db_user" class="form-label">نام کاربری دیتابیس *</label>
                        <input type="text" id="db_user" name="db_user" class="form-input" 
                               value="<?php echo htmlspecialchars($db_user); ?>" 
                               placeholder="نام کاربری" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="db_pass" class="form-label">رمز عبور دیتابیس</label>
                        <input type="password" id="db_pass" name="db_pass" class="form-input" 
                               value="<?php echo htmlspecialchars($db_pass); ?>" 
                               placeholder="رمز عبور (می‌تواند خالی باشد)">
                    </div>
                    
                    <button type="submit" class="btn-install">
                        <?php echo $install_type === 'update' ? 'ذخیره اطلاعات و اتصال' : 'تست اتصال و ادامه'; ?>
                    </button>
                    
                    <a href="?step=0" style="display: block; text-align: center; margin-top: 1rem; color: rgba(255, 255, 255, 0.7); text-decoration: none;">
                        بازگشت به انتخاب نوع نصب
                    </a>
                </form>
            <?php elseif ($step === 2): ?>
                <form method="POST" action="">
                    <input type="hidden" name="step" value="2">
                    
                    <div class="db-info">
                        <div class="db-info-item">
                            <span class="db-info-label">سرور:</span>
                            <span><?php echo htmlspecialchars($db_host); ?></span>
                        </div>
                        <div class="db-info-item">
                            <span class="db-info-label">دیتابیس:</span>
                            <span><?php echo htmlspecialchars($db_name); ?></span>
                        </div>
                        <div class="db-info-item">
                            <span class="db-info-label">کاربر:</span>
                            <span><?php echo htmlspecialchars($db_user); ?></span>
                        </div>
                    </div>
                    
                    <div class="alert alert-danger">
                        <strong>هشدار:</strong> با ادامه نصب، تمام داده‌های موجود در دیتابیس <strong><?php echo htmlspecialchars($db_name); ?></strong> پاک شده و جداول جدید ایجاد می‌شوند.
                    </div>
                    
                    <h3 style="color: #c5912c; margin: 2rem 0 1.5rem; font-size: 1.25rem;">اطلاعات مدیر سیستم</h3>
                    
                    <div class="form-group">
                        <label for="admin_username" class="form-label">نام کاربری مدیر *</label>
                        <input type="text" id="admin_username" name="admin_username" class="form-input" 
                               value="<?php echo htmlspecialchars($_POST['admin_username'] ?? ''); ?>" 
                               placeholder="نام کاربری" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="admin_password" class="form-label">رمز عبور مدیر *</label>
                        <input type="password" id="admin_password" name="admin_password" class="form-input" 
                               placeholder="حداقل 8 کاراکتر" required minlength="8">
                        <div class="info-text">رمز عبور باید حداقل 8 کاراکتر باشد</div>
                    </div>
                    
                    <div class="form-group">
                        <label for="admin_email" class="form-label">ایمیل مدیر</label>
                        <input type="email" id="admin_email" name="admin_email" class="form-input" 
                               value="<?php echo htmlspecialchars($_POST['admin_email'] ?? ''); ?>" 
                               placeholder="email@example.com">
                        <div class="info-text">برای دریافت اعلان‌های امنیتی</div>
                    </div>
                    
                    <button type="submit" class="btn-install" onclick="return confirm('آیا مطمئن هستید؟ تمام داده‌های دیتابیس پاک می‌شوند!');">
                        پاک کردن و نصب دیتابیس
                    </button>
                </form>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>
<?php
// Flush output buffer
ob_end_flush();
?>
