<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

try {
    require_once 'config/database.php';
    
    $database = new Database();
    $pdo = $database->getConnection();
    
    // Get POST data
    $rawInput = file_get_contents('php://input');
    
    
    $input = json_decode($rawInput, true);
    
    if (!$input) {
        throw new Exception('Invalid input data: ' . json_last_error_msg());
    }
    
    // Validate settings
    $settings = [
        'auto_block_enabled' => isset($input['auto_block_enabled']) ? $input['auto_block_enabled'] : '0',
        'risk_threshold' => isset($input['risk_threshold']) ? intval($input['risk_threshold']) : 80,
        'geographic_risk_enabled' => isset($input['geographic_risk_enabled']) ? $input['geographic_risk_enabled'] : '0',
        'email_alerts' => isset($input['email_alerts']) ? $input['email_alerts'] : '0',
        'email_recipient' => isset($input['email_recipient']) ? trim($input['email_recipient']) : '',
        'email_frequency' => isset($input['email_frequency']) ? $input['email_frequency'] : 'immediate',
        'email_alert_level' => isset($input['email_alert_level']) ? $input['email_alert_level'] : 'high'
    ];
    
    // Validate risk threshold
    if ($settings['risk_threshold'] < 0 || $settings['risk_threshold'] > 100) {
        throw new Exception('Risk threshold must be between 0 and 100');
    }
    
    // Save settings to database
    $stmt = $pdo->prepare("INSERT INTO threat_detection_settings (setting_key, setting_value, updated_at) VALUES (?, ?, NOW()) ON DUPLICATE KEY UPDATE setting_value = ?, updated_at = NOW()");
    
    foreach ($settings as $key => $value) {
        $stmt->execute([$key, $value, $value]);
    }
    
    // Return success response
    echo json_encode([
        'success' => true,
        'message' => 'تنظیمات با موفقیت ذخیره شد',
        'settings' => $settings,
        'timestamp' => date('Y-m-d H:i:s')
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'خطا در ذخیره تنظیمات: ' . $e->getMessage()
    ]);
}
?>
